<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Model\Icon;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Filesystem;
use Magento\Framework\Filesystem\Io\FileFactory;

class GetMediaPath
{
    public const ICONS_PATH = 'amasty/stockstatus/';

    /**
     * @var Filesystem
     */
    private $filesystem;

    /**
     * @var FileFactory
     */
    private $ioFile;

    public function __construct(
        Filesystem $filesystem,
        FileFactory $ioFileFactory
    ) {
        $this->filesystem = $filesystem;
        $this->ioFile = $ioFileFactory->create();
    }

    /**
     * @param string|null $fileName
     * @return string
     * @throws LocalizedException
     */
    public function execute(?string $fileName = null): string
    {
        $path = $this->filesystem->getDirectoryRead(
            DirectoryList::MEDIA
        )->getAbsolutePath(
            static::ICONS_PATH
        );

        $this->ioFile->checkAndCreateFolder($path);

        return $fileName ? $path . $fileName : $path;
    }
}
