<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Model\Icon;

use Magento\Framework\UrlInterface;

class GetIconUrlByPath
{
    /**
     * @var UrlInterface
     */
    private $urlBuilder;

    public function __construct(
        UrlInterface $urlBuilder
    ) {
        $this->urlBuilder = $urlBuilder;
    }

    public function execute(string $path): ?string
    {
        return $this->urlBuilder->getDirectUrl(
            GetMediaPath::ICONS_PATH . $path,
            ['_type' => UrlInterface::URL_TYPE_MEDIA]
        );
    }
}
