<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Api\StockstatusSettings;

/**
 * @api
 */
interface RemoveStockstatusSettingsIconFileInterface
{
    /**
     * Remove Stockstatus Icon by store id and Stockstatus attribute option id
     *
     * @param int $optionId
     * @param int $storeId
     */
    public function execute(int $optionId, int $storeId): void;
}
