<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Api\StockstatusSettings;

use Amasty\Stockstatus\Api\Data\StockstatusSettingsInterface;

/**
 * @api
 */
interface GetIconUrlByStockstatusSettingInterface
{
    /**
     * Get Stockstatus icon url (if exists) by Stockstatus Settings model
     *
     * @param StockstatusSettingsInterface $stockstatusSettings
     * @return string|null
     */
    public function execute(StockstatusSettingsInterface $stockstatusSettings): ?string;
}
