<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Api\Icon;

/**
 * @api
 */
interface UploadIconInterface
{
    /**
     * Upload icon file and link it to Stockstatus setting
     *
     * @param int $optionId
     * @param int $storeId
     * @param array $file
     */
    public function execute(int $optionId, int $storeId, array $file): void;
}
