<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Api\Icon;

/**
 * @api
 */
interface RemoveIconFileInterface
{
    /**
     * Remove only icon file from Stockstatus settings by option id and store id
     *
     * @param int $optionId
     * @param int $storeId
     */
    public function execute(int $optionId, int $storeId): void;
}
