<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Api\Icon;

use Amasty\Stockstatus\Api\Data\IconInterface;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * @api
 */
interface GetByOptionIdInterface
{
    /**
     * Load icon from Stockstatus settings
     *
     * @param int $optionId
     * @param int $storeId
     * @return IconInterface
     * @throws NoSuchEntityException
     */
    public function execute(int $optionId, int $storeId): IconInterface;
}
