<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Api\Data;

/**
 * @api
 */
interface StockstatusSettingsInterface
{
    public const MAIN_TABLE = 'amasty_stockstatus_additional_settings';

    public const ID = 'id';
    public const OPTION_ID = 'option_id';
    public const STORE_ID = 'store_id';
    public const IMAGE_PATH = 'image_path';
    public const TOOLTIP_TEXT = 'tooltip_text';

    /**
     * @return int|null
     */
    public function getId();

    /**
     * @param int $id
     */
    public function setId($id);

    /**
     * @return int|null
     */
    public function getOptionId(): ?int;

    /**
     * @param int $optionId
     */
    public function setOptionId(int $optionId): void;

    /**
     * @return int|null
     */
    public function getStoreId(): ?int;

    /**
     * @param int $storeId
     */
    public function setStoreId(int $storeId): void;

    /**
     * @return string|null
     */
    public function getImagePath(): ?string;

    /**
     * @param string|null $imagePath
     */
    public function setImagePath(?string $imagePath): void;

    /**
     * @return string|null
     */
    public function getTooltipText(): ?string;

    /**
     * @param string $tooltipText
     */
    public function setTooltipText(string $tooltipText): void;
}
