<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Api\Data;

interface StockstatusInformationInterface
{
    public const RULE_ID = 'rule_id';
    public const STATUS_ID = 'id';
    public const STATUS_MESSAGE = 'message';
    public const STATUS_ICON = 'icon';
    public const TOOLTIP_TEXT = 'tooltip_text';

    /**
     * @param int|null $ruleId
     * @return void
     */
    public function setRuleId(?int $ruleId): void;

    /**
     * @return int|null
     */
    public function getRuleId(): ?int;

    /**
     * @param int|null $id
     * @return void
     */
    public function setStatusId(?int $id): void;

    /**
     * @return int|null
     */
    public function getStatusId(): ?int;

    /**
     * @param string $message
     * @return void
     */
    public function setStatusMessage(string $message): void;

    /**
     * @return string
     */
    public function getStatusMessage(): string;

    /**
     * @param string|null $iconUrl
     * @return void
     */
    public function setStatusIcon(?string $iconUrl): void;

    /**
     * @return string|null
     */
    public function getStatusIcon(): ?string;

    /**
     * @return string|null
     */
    public function getTooltipText(): ?string;

    /**
     * @param string|null $tooltipText
     * @return mixed
     */
    public function setTooltipText(?string $tooltipText): void;
}
