<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Availability Status Base for Magento 2
 */

namespace Amasty\Stockstatus\Api\Data;

interface IconInterface
{
    public const MAIN_TABLE = 'amasty_stockstatus_icon';

    public const ID = 'id';
    public const OPTION_ID = 'option_id';
    public const STORE_ID = 'store_id';
    public const PATH = 'path';

    /**
     * @return int
     */
    public function getId();

    /**
     * @param int $id
     */
    public function setId($id);

    /**
     * @return int
     */
    public function getOptionId(): int;

    /**
     * @param int $optionId
     * @return void
     */
    public function setOptionId(int $optionId): void;

    /**
     * @return int
     */
    public function getStoreId(): int;

    /**
     * @param int $storeId
     * @return void
     */
    public function setStoreId(int $storeId): void;

    /**
     * @return string|null
     */
    public function getPath(): ?string;

    /**
     * @param string $path
     * @return void
     */
    public function setPath(string $path): void;
}
