<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Social Login Base for Magento 2
 */

namespace Amasty\SocialLogin\Model\Source;

class Shape implements \Magento\Framework\Option\ArrayInterface
{
    const ROUND = 0;

    const RECTANGULAR = 1;

    const SQUARE = 2;

    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $options = [];
        foreach ($this->toArray() as $optionValue => $optionLabel) {
            $options[] = ['value' => $optionValue, 'label' => $optionLabel];
        }
        return $options;
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        return [
            self::ROUND => __('Round Buttons'),
            self::RECTANGULAR => __('Rectangular Buttons'),
            self::SQUARE => __('Square Buttons')
        ];
    }
}
