<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop by SEO Redirect
 */

namespace Amasty\ShopByRedirect\Plugin;

use Amasty\ShopbyBase\Model\Category\Manager;
use Amasty\ShopbyBrand\Controller\Index\Index;
use Amasty\ShopByRedirect\Model\RedirectResolver;
use Closure;

/**
 * Redirect to SEO url
 */
class ShopByBrands
{
    /**
     * @var RedirectResolver
     */
    private $redirectResolver;

    /**
     * @var Manager
     */
    private $categoryManager;

    public function __construct(
        RedirectResolver $redirectResolver,
        Manager $categoryManager
    ) {
        $this->redirectResolver = $redirectResolver;
        $this->categoryManager = $categoryManager;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function aroundExecute(Index $subject, Closure $proceed)
    {
        if (!$this->redirectResolver->isRedirectAllowed()) {
            return $proceed();
        }

        $categoryId = (int)$this->categoryManager->getRootCategoryId();

        return $this->redirectResolver->resolveRedirect($categoryId) ?? $proceed();
    }
}
