<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop by SEO Redirect
 */

namespace Amasty\ShopByRedirect\Plugin;

use Amasty\ShopByRedirect\Model\RedirectResolver;
use Closure;
use Magento\Catalog\Controller\Category\View;
use Magento\Framework\App\RequestInterface;

/**
 * Redirect to SEO url
 */
class CatalogCategoryView
{
    /**
     * @var RedirectResolver
     */
    private $redirectResolver;

    /**
     * @var RequestInterface
     */
    private $request;

    public function __construct(
        RedirectResolver $redirectResolver,
        RequestInterface $request
    ) {
        $this->redirectResolver = $redirectResolver;
        $this->request = $request;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function aroundExecute(View $subject, Closure $proceed)
    {
        if (!$this->redirectResolver->isRedirectAllowed()) {
            return $proceed();
        }

        $categoryId = (int)$this->request->getParam('id', 0);

        return $this->redirectResolver->resolveRedirect($categoryId) ?? $proceed();
    }
}
