<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shop by SEO Redirect
 */

namespace Amasty\ShopByRedirect\Model;

use Amasty\Base\Model\ConfigProviderAbstract;
use Amasty\ShopbySeo\Model\ConfigProvider as SeoConfigProvider;

class ConfigProvider extends ConfigProviderAbstract
{
    /**
     * @var string
     */
    protected $pathPrefix = 'amasty_shopby_seo/';

    /**
     * Use 301 Redirect for SEO-optimized URLs?
     */
    public function isRedirectToSeo(?int $storeId = null): bool
    {
        return $this->isSetFlag(SeoConfigProvider::GROUP_URL . 'redirect_to_seo', $storeId);
    }
}
