<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shipping Table Rates for Magento 2
 */

namespace Amasty\ShippingTableRates\Setup;

use Amasty\ShippingTableRates\Model\ResourceModel\Label;
use Amasty\ShippingTableRates\Model\ResourceModel\Method;
use Amasty\ShippingTableRates\Model\ResourceModel\Rate;
use Magento\Catalog\Model\Product;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UninstallInterface;

class Uninstall implements UninstallInterface
{
    public const AM_SHIPPING_TYPE = 'am_shipping_type';
    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @var EavSetupFactory
     */
    private $eavSetupFactory;

    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    public function uninstall(SchemaSetupInterface $setup, ModuleContextInterface $context): void
    {
        $setup->getConnection()
            ->dropTable($setup->getTable(Label::MAIN_TABLE));
        $setup->getConnection()
            ->dropTable($setup->getTable(Rate::SOURCES_TABLE));
        $setup->getConnection()
            ->dropTable($setup->getTable(Rate::MAIN_TABLE));
        $setup->getConnection()
            ->dropTable($setup->getTable(Rate::MAIN_TABLE . '_replica'));
        $setup->getConnection()
            ->dropTable($setup->getTable(Method::MAIN_TABLE));

        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);

        if ($eavSetup->getAttribute(Product::ENTITY, self::AM_SHIPPING_TYPE)) {
            $eavSetup->removeAttribute(Product::ENTITY, self::AM_SHIPPING_TYPE);
        }
    }
}
