<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Shipping Table Rates for Magento 2
 */

namespace Amasty\ShippingTableRates\Model;

use Magento\Catalog\Model\ResourceModel\Product as ProductResource;
use Magento\CatalogInventory\Model\Stock;
use Magento\CatalogInventory\Model\StockRegistryProvider;
use Magento\Store\Model\StoreManagerInterface;

class BackordersValidator
{
    public const ALLOWED_STATUSES = [
        Stock::BACKORDERS_YES_NONOTIFY,
        Stock::BACKORDERS_YES_NOTIFY
    ];

    /**
     * @var StockRegistryProvider
     */
    private $stockRegistryProvider;

    /**
     * @var ProductResource
     */
    private $productResource;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        StockRegistryProvider $stockRegistryProvider,
        ProductResource $productResource,
        StoreManagerInterface $storeManager
    ) {
        $this->stockRegistryProvider = $stockRegistryProvider;
        $this->productResource = $productResource;
        $this->storeManager = $storeManager;
    }

    public function isAllowedQtyBelowZero(string $sku): bool
    {
        $isAllowed = false;

        $productId = (int)$this->productResource->getIdBySku($sku);
        $websiteId = (int)$this->storeManager->getStore()->getWebsiteId();
        if ($productId && $websiteId) {
            $product = $this->stockRegistryProvider->getStockItem($productId, $websiteId);
            $isAllowed = in_array($product->getBackorders(), self::ALLOWED_STATUSES);
        }

        return $isAllowed;
    }
}
