<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Two-Factor Authentication for Magento 2
*/
declare(strict_types=1);

namespace Amasty\SecurityAuth\Block\Adminhtml;

use Amasty\SecurityAuth\Helper\Data;
use Magento\Backend\Block\Template;

class SecurityCode extends Template
{
    /**
     * @var Data
     */
    private $helper;

    public function __construct(
        Template\Context $context,
        Data $helper,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->helper = $helper;
    }

    public function isActive(): bool
    {
        return (bool)$this->helper->isActive();
    }
}
