<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Two-Factor Authentication for Magento 2
*/

namespace Amasty\SecurityAuth\Api\Data;

interface AuthInterface
{
    public const ID = 'id';

    public const USER_ID = 'user_id';

    public const ENABLE = 'enable';

    public const TWO_FACTOR_TOKEN = 'two_factor_token';

    /**
     * @return int
     */
    public function getId();

    /**
     * @param int $id
     * @return \Amasty\SecurityAuth\Api\Data\AuthInterface
     */
    public function setId($id);

    /**
     * @return int
     */
    public function getUserId();

    /**
     * @param int $id
     * @return \Amasty\SecurityAuth\Api\Data\AuthInterface
     */
    public function setUserId($id);
    
    /**
     * @return string
     */
    public function getEnable();

    /**
     * @param string $enable
     * @return \Amasty\SecurityAuth\Api\Data\AuthInterface
     */
    public function setEnable($enable);

    /**
     * @return int
     */
    public function getTwoFactorToken();

    /**
     * @param int $token
     * @return \Amasty\SecurityAuth\Api\Data\AuthInterface
     */
    public function setTwoFactorToken($token);
}
