<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Two-Factor Authentication for Magento 2
*/

namespace Amasty\SecurityAuth\Api;

use Amasty\SecurityAuth\Api\Data\AuthInterface;

interface AuthRepositoryInterface
{
    /**
     * @param int $id Flag ID.
     * @return AuthInterface
     */
    public function get($id);

    /**
     * @param AuthInterface $entity
     * @return mixed
     */
    public function delete(AuthInterface $entity);

    /**
     * @param AuthInterface $entity
     * @return mixed
     */
    public function save(AuthInterface $entity);
}
