<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\Validator;

use Amasty\RmaGraphQl\Model\Request\CreateReturnRequest as RequestConst;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;

class PlaceRequest
{
    public function validateInput(array $args): void
    {
        $input = $args['input'] ?? [];

        if (!isset($input[RequestConst::ORDER_ID_KEY]) || empty($input[RequestConst::ORDER_ID_KEY])) {
            throw new GraphQlInputException(__('Required parameter "%1" is missing', RequestConst::ORDER_ID_KEY));
        }

        if (!isset($input[RequestConst::RETURN_ITEMS_KEY]) || empty($input[RequestConst::RETURN_ITEMS_KEY])) {
            throw new GraphQlInputException(__('Required parameter "%1" is missing', RequestConst::RETURN_ITEMS_KEY));
        }
    }
}
