<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\TrackingNumber;

use Amasty\Rma\Api\CustomerRequestRepositoryInterface;
use Amasty\RmaGraphQl\Model\Formatter\CommonOutput;
use Amasty\RmaGraphQl\Model\Request\ValidatedRequestProvider;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class RemoveTrackingNumber implements ResolverInterface
{
    /**
     * @var ValidatedRequestProvider
     */
    private $requestProvider;

    /**
     * @var CustomerRequestRepositoryInterface
     */
    private $requestRepository;

    /**
     * @var CommonOutput
     */
    private $commonOutputFormatter;

    public function __construct(
        ValidatedRequestProvider $requestProvider,
        CustomerRequestRepositoryInterface $requestRepository,
        CommonOutput $commonOutputFormatter
    ) {
        $this->requestProvider = $requestProvider;
        $this->requestRepository = $requestRepository;
        $this->commonOutputFormatter = $commonOutputFormatter;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $args = $args['input'];

        $request = $this->requestProvider->getByHash(
            $args['hash'],
            $context,
            __('Customer isn\'t authorized to delete tracking number of that return request.')
        );
        try {
            $isDeleted = $this->requestRepository->removeTracking($request->getUrlHash(), $args['tracking_id']);
        } catch (\Exception $e) {
            $isDeleted = false;
        }

        if (!$isDeleted) {
            return $this->commonOutputFormatter->format(
                __('Something went wrong while deleting the tracking number'),
                true
            );
        }

        return $this->commonOutputFormatter->format(__('Tracking Number has been successfully deleted.'));
    }
}
