<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\TrackingNumber;

use Amasty\Rma\Api\CustomerRequestRepositoryInterface;
use Amasty\RmaGraphQl\Model\Request\ValidatedRequestProvider;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class AddTrackingNumber implements ResolverInterface
{
    /**
     * @var ValidatedRequestProvider
     */
    private $requestProvider;

    /**
     * @var CustomerRequestRepositoryInterface
     */
    private $requestRepository;

    public function __construct(
        ValidatedRequestProvider $requestProvider,
        CustomerRequestRepositoryInterface $requestRepository
    ) {
        $this->requestProvider = $requestProvider;
        $this->requestRepository = $requestRepository;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $args = $args['input'];

        $request = $this->requestProvider->getByHash(
            $args['hash'],
            $context,
            __('Customer isn\'t authorized to add tracking number to that return request.')
        );
        $tracking = $this->requestRepository->getEmptyTrackingModel();
        $tracking->setTrackingCode($args['code'])
            ->setTrackingNumber($args['number']);
        $this->requestRepository->saveTracking($request->getUrlHash(), $tracking);

        return $tracking;
    }
}
