<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\Order;

use Amasty\Rma\Api\CreateReturnProcessorInterface;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Sales\Api\Data\OrderInterface;

class IsReturnable implements ResolverInterface
{
    /**
     * @var CreateReturnProcessorInterface
     */
    private $returnProcessor;

    public function __construct(CreateReturnProcessorInterface $returnProcessor)
    {
        $this->returnProcessor = $returnProcessor;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        if (!isset($value['model'])) {
            throw new GraphQlInputException(__('"model" value should be specified'));
        }
        /** @var OrderInterface $order */
        $order = $value['model'];
        $returnOrder = $this->returnProcessor->process($order->getId());
        $returnItems = $returnOrder ? $returnOrder->getItems() : [];

        foreach ($returnItems as $returnItem) {
            if ($returnItem->isReturnable()) {
                return true;
            }
        }

        return false;
    }
}
