<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver;

use Amasty\Rma\Model\ConfigProvider;
use Magento\Cms\Helper\Page;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetSettings implements ResolverInterface
{
    /**
     * @var Page
     */
    private $pageHelper;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        Page $pageHelper,
        ConfigProvider $configProvider
    ) {
        $this->pageHelper = $pageHelper;
        $this->configProvider = $configProvider;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $storeId = (int)$context->getExtensionAttributes()->getStore()->getId();
        $isShowAdministratorContact = $this->configProvider->isShowAdministratorContact();
        $settings = [
            'isEnabled' => $this->configProvider->isEnabled(),
            'isChatEnabled' => $this->configProvider->isChatEnabled($storeId),
            'isReturnPolicyEnabled' => $this->configProvider->isReturnPolicyEnabled(),
            'isAskForFeedback' => $this->configProvider->isEnableFeedback($storeId),
            'maxAttachmentSize' => $this->configProvider->getMaxFileSize(),
            'isShowAdministratorContact' => $this->configProvider->isShowAdministratorContact(),
            'urlPrefix' => $this->configProvider->getUrlPrefix($storeId),
            'policyUrl' => $this->pageHelper->getPageUrl($this->configProvider->getReturnPolicyPage()),
            'shippingCarriers' => $this->configProvider->getCarriers($storeId),
            'customFieldsBlockTitle' => $this->configProvider->getCustomFieldsLabel($storeId),
            'customFields' => $this->getCustomFields($storeId)
        ];

        if ($isShowAdministratorContact) {
            $settings['administratorPhoneNumber'] = $this->configProvider->getAdministratorPhoneNumber();
            $settings['administratorEmail'] = $this->configProvider->getAdministratorEmail();
        }

        return $settings;
    }

    private function getCustomFields(int $storeId): array
    {
        $customFields = [];

        foreach ($this->configProvider->getCustomFields($storeId) as $code => $label) {
            $customFields[] = [
                'code' => $code,
                'title' => $label
            ];
        }

        return $customFields;
    }
}
