<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver;

use Amasty\Rma\Model\ConfigProvider;
use Magento\Cms\Api\PageRepositoryInterface;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetReturnPolicy implements ResolverInterface
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;
    /**
     * @var PageRepositoryInterface
     */
    private $pageRepository;

    public function __construct(
        ConfigProvider $configProvider,
        PageRepositoryInterface $pageRepository
    ) {
        $this->configProvider = $configProvider;
        $this->pageRepository = $pageRepository;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $cmsPageId = $this->configProvider->getReturnPolicyPage();

        try {
            $cmsPage = $this->pageRepository->getById($cmsPageId);

            $result = [
                'title' => $cmsPage->getTitle() ?: __('Return Policy'),
                'content' => $cmsPage->getContent() ?: ''
            ];
        } catch (\Exception $e) {
            $result = [];
        }

        return $result;
    }
}
