<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver;

use Amasty\Rma\Api\StatusRepositoryInterface;
use Magento\Cms\Model\Template\FilterProvider;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetReturnInstruction implements ResolverInterface
{
    /**
     * @var StatusRepositoryInterface
     */
    private $statusRepository;

    /**
     * @var FilterProvider
     */
    private $filterProvider;

    public function __construct(
        StatusRepositoryInterface $statusRepository,
        FilterProvider $filterProvider
    ) {
        $this->statusRepository = $statusRepository;
        $this->filterProvider = $filterProvider;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $statusId = (int)$args['status_id'] ?? 0;
        $storeId = (int)$context->getExtensionAttributes()->getStore()->getId();

        try {
            $status = $this->statusRepository->getById($statusId, $storeId);
        } catch (NoSuchEntityException $e) {
            throw new GraphQlInputException(__('Non existing status_id was provided.'));
        }

        /** @var \Amasty\Rma\Api\Data\StatusStoreInterface $statusStore */
        $statusStore = $status->getStore();
        $description = (string)preg_replace('/{{widget[^}]+}}/i', '', $statusStore->getDescription());

        return $this->filterProvider->getPageFilter()->filter($description);
    }
}
