<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver;

use Amasty\Rma\Api\ResolutionRepositoryInterface;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetResolutions implements ResolverInterface
{
    /**
     * @var ResolutionRepositoryInterface
     */
    private $resolutionRepository;

    public function __construct(ResolutionRepositoryInterface $resolutionRepository)
    {
        $this->resolutionRepository = $resolutionRepository;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $storeId = (int)$context->getExtensionAttributes()->getStore()->getId();

        return $this->resolutionRepository->getResolutionsByStoreId($storeId);
    }
}
