<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver;

use Amasty\Rma\Api\Data\RequestItemInterface;
use Amasty\Rma\Model\OptionSource\ItemStatus;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetItemStatus implements ResolverInterface
{
    /**
     * @var ItemStatus
     */
    private $itemStatus;

    public function __construct(
        ItemStatus $itemStatus
    ) {
        $this->itemStatus = $itemStatus;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        if (isset($value[RequestItemInterface::ITEM_STATUS])) {
            return $this->itemStatus->toArray()[$value[RequestItemInterface::ITEM_STATUS]] ?? '';
        }

        return '';
    }
}
