<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\Customer;

use Amasty\Rma\Api\Data\RequestInterface;
use Amasty\RmaGraphQl\Model\Formatter\ReturnRequest;
use Amasty\RmaGraphQl\Model\Request\Finder;
use Magento\CustomerGraphQl\Model\Customer\GetCustomer;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class SearchReturns implements ResolverInterface
{
    /**
     * @var SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;

    /**
     * @var GetCustomer
     */
    private $getCustomer;

    /**
     * @var ReturnRequest
     */
    private $requestFormatter;

    /**
     * @var Finder
     */
    private $requestFinder;

    public function __construct(
        SearchCriteriaBuilder $searchCriteriaBuilder,
        ReturnRequest $requestFormatter,
        GetCustomer $getCustomer,
        Finder $requestFinder
    ) {
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->requestFormatter = $requestFormatter;
        $this->getCustomer = $getCustomer;
        $this->requestFinder = $requestFinder;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $storeId = (int)$context->getExtensionAttributes()->getStore()->getId();
        $customer = $this->getCustomer->execute($context);
        $this->searchCriteriaBuilder->addFilter(RequestInterface::CUSTOMER_ID, $customer->getId());

        if ($args['pageSize'] < 1) {
            throw new GraphQlInputException(__('pageSize value must be greater than 0.'));
        }

        if ($args['currentPage'] < 1) {
            throw new GraphQlInputException(__('currentPage value must be greater than 0.'));
        }

        $this->searchCriteriaBuilder->setCurrentPage($args['currentPage']);
        $this->searchCriteriaBuilder->setPageSize($args['pageSize']);
        $searchResults = $this->requestFinder->getList($this->searchCriteriaBuilder->create());

        return $this->requestFormatter->format($searchResults, $storeId);
    }
}
