<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\Customer;

use Amasty\Rma\Model\Request\CustomerRequestRepository;
use Amasty\RmaGraphQl\Model\Formatter\CommonOutput;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class RateReturnRequest implements ResolverInterface
{
    /**
     * @var CommonOutput
     */
    private $commonOutputFormatter;

    /**
     * @var CustomerRequestRepository
     */
    private $customerRequestRepository;

    public function __construct(
        CommonOutput $commonOutputFormatter,
        CustomerRequestRepository $customerRequestRepository
    ) {
        $this->commonOutputFormatter = $commonOutputFormatter;
        $this->customerRequestRepository = $customerRequestRepository;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $args = $args['input'];
        $hash = $args['hash'];
        $rating = $args['rating'];
        $comment = $args['comment'];

        if ($rating <= 0 || $rating >= 6) {
            throw new GraphQlInputException(__('\'rating\' value must be in range from 1 to 5'));
        }

        $result = $this->customerRequestRepository->saveRating($hash, (int)$rating, $comment);
        if ($result === false) {
            return $this->commonOutputFormatter->format(__('Couldn\'t rate request.'), true);
        }

        return $this->commonOutputFormatter->format(__('Request was successfully rated.'));
    }
}
