<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\Customer;

use Amasty\RmaGraphQl\Model\Formatter\RequestData;
use Amasty\RmaGraphQl\Model\Request\ValidatedRequestProvider;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetReturnRequest implements ResolverInterface
{
    /**
     * @var ValidatedRequestProvider
     */
    private $requestProvider;

    /**
     * @var RequestData
     */
    private $requestDataFormatter;

    public function __construct(
        ValidatedRequestProvider $requestProvider,
        RequestData $requestDataFormatter
    ) {
        $this->requestProvider = $requestProvider;
        $this->requestDataFormatter = $requestDataFormatter;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $storeId = (int)$context->getExtensionAttributes()->getStore()->getId();
        $requestId = (int)$args['request_id'];

        $request = $this->requestProvider->getById(
            $requestId,
            $context,
            __('Customer isn\'t authorized to view that return request.')
        );

        return $this->requestDataFormatter->prepareRequestData($request, $storeId);
    }
}
