<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\Customer;

use Amasty\Rma\Api\Data\RequestInterface;
use Amasty\RmaGraphQl\Model\Formatter\ReturnRequest;
use Amasty\RmaGraphQl\Model\Request\Finder;
use Magento\CustomerGraphQl\Model\Customer\GetCustomer;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\Api\SortOrder;
use Magento\Framework\Api\SortOrderBuilder;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class CustomerReturns implements ResolverInterface
{
    /**
     * @var SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;

    /**
     * @var SortOrderBuilder
     */
    private $sortOrderBuilder;

    /**
     * @var GetCustomer
     */
    private $getCustomer;

    /**
     * @var Finder
     */
    private $requestFinder;

    /**
     * @var ReturnRequest
     */
    private $requestFormatter;

    public function __construct(
        SearchCriteriaBuilder $searchCriteriaBuilder,
        SortOrderBuilder $sortOrderBuilder,
        GetCustomer $getCustomer,
        Finder $requestFinder,
        ReturnRequest $requestFormatter
    ) {
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->getCustomer = $getCustomer;
        $this->requestFinder = $requestFinder;
        $this->requestFormatter = $requestFormatter;
        $this->sortOrderBuilder = $sortOrderBuilder;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $storeId = (int)$context->getExtensionAttributes()->getStore()->getId();
        $customer = $this->getCustomer->execute($context);
        $this->searchCriteriaBuilder->addFilter(RequestInterface::CUSTOMER_ID, $customer->getId());
        $this->searchCriteriaBuilder->addSortOrder(
            $this->sortOrderBuilder->setField(RequestInterface::REQUEST_ID)
                ->setDirection(SortOrder::SORT_DESC)
                ->create()
        );
        $searchResults = $this->requestFinder->getList($this->searchCriteriaBuilder->create());

        return $this->requestFormatter->format($searchResults, $storeId)['items'] ?? [];
    }
}
