<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\Customer;

use Amasty\Rma\Api\CustomerRequestRepositoryInterface;
use Amasty\RmaGraphQl\Model\Formatter\CommonOutput;
use Magento\CustomerGraphQl\Model\Customer\GetCustomer;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlAuthorizationException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class CancelReturnRequest implements ResolverInterface
{
    public const ID = 'id';

    /**
     * @var GetCustomer
     */
    private $getCustomer;

    /**
     * @var CustomerRequestRepositoryInterface
     */
    private $customerRequestRepository;

    /**
     * @var CommonOutput
     */
    private $commonOutputFormatter;

    public function __construct(
        GetCustomer $getCustomer,
        CustomerRequestRepositoryInterface $customerRequestRepository,
        CommonOutput $commonOutputFormatter
    ) {
        $this->getCustomer = $getCustomer;
        $this->customerRequestRepository = $customerRequestRepository;
        $this->commonOutputFormatter = $commonOutputFormatter;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        if (!$context->getExtensionAttributes()->getIsCustomer()) {
            throw new GraphQlAuthorizationException(__('Customer is not authorized.'));
        }
        if (!($requestId = $args[self::ID] ?? null)) {
            throw new GraphQlAuthorizationException(__('No request ID provided.'));
        }
        $customer = $this->getCustomer->execute($context);

        try {
            $this->customerRequestRepository->closeRequest($requestId, $customer->getId());

            return $this->commonOutputFormatter->format(__('Return Request successfully closed.'));
        } catch (\Exception $e) {
            return $this->commonOutputFormatter->format(__($e->getMessage()), true);
        }
    }
}
