<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\Chat;

use Amasty\Rma\Api\ChatRepositoryInterface;
use Amasty\RmaGraphQl\Model\Formatter\Message;
use Amasty\RmaGraphQl\Model\Request\ValidatedRequestProvider;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class SendRequestMessage implements ResolverInterface
{
    public const FILEHASH = 'filehash';
    public const FILENAME = 'filename';

    /**
     * @var Message
     */
    private $messageFormatter;

    /**
     * @var ValidatedRequestProvider
     */
    private $requestProvider;

    /**
     * @var ChatRepositoryInterface
     */
    private $chatRepository;

    public function __construct(
        Message $messageFormatter,
        ValidatedRequestProvider $requestProvider,
        ChatRepositoryInterface $chatRepository
    ) {
        $this->messageFormatter = $messageFormatter;
        $this->requestProvider = $requestProvider;
        $this->chatRepository = $chatRepository;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $args = $args['input'];
        $request = $this->requestProvider->getByHash(
            $args['hash'],
            $context,
            __('Customer isn\'t allowed to send messages for this return request')
        );

        $message = $this->chatRepository->getEmptyMessageModel();
        $message->setMessage($args['message'] ?? '')
            ->setIsManager(0)
            ->setIsRead(0)
            ->setRequestId($request->getRequestId())
            ->setCustomerId($request->getCustomerId())
            ->setName($request->getCustomerName());

        $files = $args['files'] ?? [];
        if ($files) {
            $messageFiles = [];

            foreach ($files as $file) {
                $messageFile = $this->chatRepository->getEmptyMessageFileModel();
                $messageFile->setFilepath($file[self::FILEHASH])
                    ->setFilename($file[self::FILENAME]);
                $messageFiles[] = $messageFile;
            }
            $message->setMessageFiles($messageFiles);
        }
        $this->chatRepository->save($message);

        return $this->messageFormatter->format($this->chatRepository->getById($message->getMessageId()));
    }
}
