<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\Chat;

use Amasty\Rma\Api\ChatRepositoryInterface;
use Amasty\RmaGraphQl\Model\Formatter\Message;
use Amasty\RmaGraphQl\Model\Request\ValidatedRequestProvider;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetRequestMessages implements ResolverInterface
{
    /**
     * @var ChatRepositoryInterface
     */
    private $chatRepository;

    /**
     * @var ValidatedRequestProvider
     */
    private $requestProvider;

    /**
     * @var Message
     */
    private $messageFormatter;

    public function __construct(
        ChatRepositoryInterface $chatRepository,
        ValidatedRequestProvider $requestProvider,
        Message $messageFormatter
    ) {
        $this->chatRepository = $chatRepository;
        $this->requestProvider = $requestProvider;
        $this->messageFormatter = $messageFormatter;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $hash = $args['hash'];
        $lastId = (int)($args['last_message_id'] ?? 0);

        $request = $this->requestProvider->getByHash(
            $hash,
            $context,
            __('Customer isn\'t allowed to view messages of this return request')
        );

        $result = [];
        foreach ($this->chatRepository->getMessagesByRequestId($request->getRequestId(), $lastId) as $message) {
            $result[] = $this->messageFormatter->format($message);
        }

        return $result;
    }
}
