<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\Chat;

use Amasty\Rma\Utils\FileUpload;
use Amasty\RmaGraphQl\Model\Formatter\CommonOutput;
use Amasty\RmaGraphQl\Model\Request\ValidatedRequestProvider;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class DeleteTempFile implements ResolverInterface
{
    /**
     * @var FileUpload
     */
    private $fileUpload;

    /**
     * @var ValidatedRequestProvider
     */
    private $requestProvider;

    /**
     * @var CommonOutput
     */
    private $commonOutputFormatter;

    public function __construct(
        FileUpload $fileUpload,
        ValidatedRequestProvider $requestProvider,
        CommonOutput $commonOutputFormatter
    ) {
        $this->fileUpload = $fileUpload;
        $this->requestProvider = $requestProvider;
        $this->commonOutputFormatter = $commonOutputFormatter;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        try {
            $this->fileUpload->deleteTemp($args['filehash']);
        } catch (\Exception $e) {
            return $this->commonOutputFormatter->format(__('Something went wrong with attachment deleting.'), true);
        }

        return $this->commonOutputFormatter->format(__('Successfully deleted.'));
    }
}
