<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\Chat;

use Amasty\Rma\Api\ChatRepositoryInterface;
use Amasty\RmaGraphQl\Model\Formatter\CommonOutput;
use Amasty\RmaGraphQl\Model\Request\ValidatedRequestProvider;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class DeleteMessage implements ResolverInterface
{
    /**
     * @var ChatRepositoryInterface
     */
    private $chatRepository;

    /**
     * @var ValidatedRequestProvider
     */
    private $requestProvider;

    /**
     * @var CommonOutput
     */
    private $commonOutputFormatter;

    public function __construct(
        ChatRepositoryInterface $chatRepository,
        ValidatedRequestProvider $requestProvider,
        CommonOutput $commonOutputFormatter
    ) {
        $this->chatRepository = $chatRepository;
        $this->requestProvider = $requestProvider;
        $this->commonOutputFormatter = $commonOutputFormatter;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $args = $args['input'];

        $request = $this->requestProvider->getByHash(
            $args['hash'],
            $context,
            __('Customer isn\'t authorized to remove chat messages of provided return request.')
        );
        try {
            $message = $this->chatRepository->getById($args['message_id']);
            if ($message->getRequestId() === $request->getRequestId()
                && !$message->isManager() && !$message->isSystem()
            ) {
                $this->chatRepository->delete($message);

                return $this->commonOutputFormatter->format(__('Message was successfully deleted.'));
            } else {
                return $this->commonOutputFormatter->format(
                    __('Customer isn\'t authorized to delete this message.'),
                    true
                );
            }
        } catch (LocalizedException $exception) {
            return $this->commonOutputFormatter->format(__('Something went wrong with message deleting.'), true);
        }
    }
}
