<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Resolver\CartItem;

use Amasty\Rma\Model\ConfigProvider;
use Amasty\Rma\Model\Resolution\ProductResolutionProcessor;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Quote\Api\Data\CartItemInterface;

class GetReturnInfo implements ResolverInterface
{
    /**
     * @var ProductResolutionProcessor
     */
    private $productResolutionProcessor;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        ProductResolutionProcessor $productResolutionProcessor,
        ConfigProvider $configProvider
    ) {
        $this->productResolutionProcessor = $productResolutionProcessor;
        $this->configProvider = $configProvider;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        if (!isset($value['model'])) {
            throw new GraphQlInputException(__('"model" value should be specified'));
        }

        if (!$this->configProvider->isEnabled()
            || !$this->configProvider->isShowRmaInfoCart()
        ) {
            return [];
        }

        /** @var CartItemInterface $cartItem */
        $cartItem = $value['model'];

        return $this->productResolutionProcessor->getResolutions($cartItem->getProduct());
    }
}
