<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Formatter;

use Amasty\RmaGraphQl\Api\Data\RequestSearchResultsInterface;

class ReturnRequest
{
    /**
     * @var RequestData
     */
    private $requestDataFormatter;

    public function __construct(
        RequestData $requestDataFormatter
    ) {
        $this->requestDataFormatter = $requestDataFormatter;
    }

    public function format(RequestSearchResultsInterface $searchResults, int $storeId): array
    {
        $pageSize = $searchResults->getSearchCriteria()->getPageSize();
        $requests = [];

        foreach ($searchResults->getItems() as $request) {
            $requests[] = $this->requestDataFormatter->prepareRequestData($request, $storeId);
        }

        return [
            'items' => $requests,
            'page_info' => [
                'page_size' => $pageSize,
                'current_page' => $searchResults->getSearchCriteria()->getCurrentPage(),
                'total_pages' => $pageSize ? ((int)ceil($searchResults->getTotalCount() / $pageSize)) : 0
            ],
            'total_count' => $searchResults->getTotalCount()
        ];
    }
}
