<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Formatter;

use Amasty\Rma\Api\Data\RequestInterface;
use Amasty\Rma\Api\StatusRepositoryInterface;
use Magento\Sales\Api\OrderRepositoryInterface;

class RequestData
{
    public const INCREMENT_ID = 'order_increment_id';
    public const PRODUCT_NAME = 'product_name';
    public const PRODUCT_URL_KEY = 'product_url_key';

    /**
     * @var StatusRepositoryInterface
     */
    private $statusRepository;

    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;

    public function __construct(
        StatusRepositoryInterface $statusRepository,
        OrderRepositoryInterface $orderRepository
    ) {
        $this->statusRepository = $statusRepository;
        $this->orderRepository = $orderRepository;
    }

    public function prepareRequestData(RequestInterface $request, int $storeId): array
    {
        $requestData = $request->getData();
        $status = $this->statusRepository->getById($request->getStatus(), $storeId);
        $status->setLabel($status->getStore()->getLabel());
        $requestData[RequestInterface::STATUS] = $status;

        try {
            $order = $this->orderRepository->get($requestData[RequestInterface::ORDER_ID]);
            $requestData[self::INCREMENT_ID] = $order->getIncrementId();

            $orderItems = $order->getItems();
            $requestData[RequestInterface::REQUEST_ITEMS] = array_map(function ($item) use ($orderItems) {
                $itemData = $item->getData();
                if (isset($orderItems[$item->getOrderItemId()])) {
                    $product = $orderItems[$item->getOrderItemId()]->getProduct();
                    $itemData[self::PRODUCT_NAME] = $product->getName();
                    $itemData[self::PRODUCT_URL_KEY] = $product->getUrlKey();
                }

                return $itemData;
            }, $requestData[RequestInterface::REQUEST_ITEMS]);
        } catch (\Exception $e) {
            $requestData[self::INCREMENT_ID] = '';
        }

        return $requestData;
    }
}
