<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Formatter;

use Amasty\Rma\Api\Data\MessageInterface;
use Amasty\Rma\Utils\FileUpload;
use Magento\Framework\App\Filesystem\DirectoryList;

class Message
{
    public function format(MessageInterface $message): array
    {
        return [
            'message_id' => $message->getMessageId(),
            'is_manager' => $message->isManager(),
            'is_system' => $message->isSystem(),
            'message' => $message->getMessage(),
            'username' => $message->getName(),
            'created' => $message->getCreatedAt(),
            'files' => $this->prepareMessageFiles($message)
        ];
    }

    private function prepareMessageFiles(MessageInterface $message): array
    {
        $result = [];

        $requestId = $message->getRequestId();
        foreach ((array)$message->getMessageFiles() as $messageFile) {
            $filePath = $messageFile->getFilepath();
            //phpcs:ignore Magento2.Functions.DiscouragedFunction
            $fileName = $messageFile->getFileName() . '.' . pathinfo($filePath, PATHINFO_EXTENSION);
            $relativePath = DIRECTORY_SEPARATOR . DirectoryList::MEDIA
                . DIRECTORY_SEPARATOR . FileUpload::MEDIA_PATH . $requestId
                . DIRECTORY_SEPARATOR . $filePath;

            $result[] = [
                'filename' => $fileName,
                'filepath' => $relativePath
            ];
        }

        return $result;
    }
}
