<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model\Formatter;

use Magento\Framework\Phrase;

class CommonOutput
{
    public const ERROR_KEY = 'error';
    public const MESSAGE_KEY = 'message';

    public function format(Phrase $message, bool $isError = false): array
    {
        return [
            self::ERROR_KEY => $isError,
            self::MESSAGE_KEY => $message
        ];
    }
}
