<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Model;

use Amasty\RmaGraphQl\Api\Data\FileContentInterface;
use Magento\Framework\DataObject;

class FileContent extends DataObject implements FileContentInterface
{
    public const BASE64_ENCODED_DATA = 'base64_encoded_data';
    public const ORIGINAL_FILE_NAME = 'original_file_name';
    public const EXTENSION = 'extension';
    public const FILEHASH = 'filehash';

    /**
     * @return string
     */
    public function getBase64EncodedData(): string
    {
        return (string)$this->_getData(self::BASE64_ENCODED_DATA);
    }

    /**
     * @param string $base64EncodedData
     *
     * @return FileContentInterface
     */
    public function setBase64EncodedData(string $base64EncodedData): FileContentInterface
    {
        return $this->setData(self::BASE64_ENCODED_DATA, $base64EncodedData);
    }

    /**
     * @return string
     */
    public function getOriginalFileName(): string
    {
        return (string)$this->_getData(self::ORIGINAL_FILE_NAME);
    }

    /**
     * @param string $originalFileName
     *
     * @return FileContentInterface
     */
    public function setOriginalFileName(string $originalFileName): FileContentInterface
    {
        return $this->setData(self::ORIGINAL_FILE_NAME, $originalFileName);
    }

    /**
     * @return string
     */
    public function getExtension(): string
    {
        return (string)$this->_getData(self::EXTENSION);
    }

    /**
     * @param string $extension
     *
     * @return FileContentInterface
     */
    public function setExtension(string $extension): FileContentInterface
    {
        return $this->setData(self::EXTENSION, $extension);
    }

    /**
     * @return string
     */
    public function getFilehash(): string
    {
        return (string)$this->_getData(self::FILEHASH);
    }

    /**
     * @param string $filehash
     *
     * @return FileContentInterface
     */
    public function setFilehash(string $filehash): FileContentInterface
    {
        return $this->setData(self::FILEHASH, $filehash);
    }
}
