<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Api;

use Amasty\RmaGraphQl\Api\Data\FileContentInterface;
use Magento\Framework\Exception\LocalizedException;

/**
 * @api
 */
interface UploadFilesInterface
{
    /**
     * Upload File
     *
     * @param \Amasty\RmaGraphQl\Api\Data\FileContentInterface[] $filesContents
     *
     * @return \Amasty\RmaGraphQl\Api\Data\FileContentInterface[]
     * @throws LocalizedException
     */
    public function upload(array $filesContents): array;
}
