<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Api;

use Amasty\RmaGraphQl\Api\Data\RequestSearchResultsInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

interface RequestFinderInterface
{
    /**
     * Retrieve RMA requests.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \Amasty\RmaGraphQl\Api\Data\RequestSearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria): RequestSearchResultsInterface;
}
