<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Api\Data;

use Magento\Framework\Api\SearchResultsInterface;

interface RequestSearchResultsInterface extends SearchResultsInterface
{
    /**
     * Get RMA requests list.
     *
     * @return \Amasty\Rma\Api\Data\RequestInterface[]
     */
    public function getItems();

    /**
     * Set RMA requests list.
     *
     * @param \Amasty\Rma\Api\Data\RequestInterface[] $items
     * @return \Amasty\RmaGraphQl\Api\Data\RequestSearchResultsInterface
     */
    public function setItems(array $items);
}
