<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package RMA GraphQl for Magento 2 (System)
 */

namespace Amasty\RmaGraphQl\Api\Data;

/**
 * @api
 */
interface FileContentInterface
{
    /**
     * @return string
     */
    public function getBase64EncodedData(): string;

    /**
     * @param string $base64EncodedData
     *
     * @return FileContentInterface
     */
    public function setBase64EncodedData(string $base64EncodedData): FileContentInterface;

    /**
     * @return string
     */
    public function getOriginalFileName(): string;

    /**
     * @param string $originalFileName
     *
     * @return FileContentInterface
     */
    public function setOriginalFileName(string $originalFileName): FileContentInterface;

    /**
     * @return string
     */
    public function getExtension(): string;

    /**
     * @param string $extension
     *
     * @return FileContentInterface
     */
    public function setExtension(string $extension): FileContentInterface;

    /**
     * @return string
     */
    public function getFilehash(): string;

    /**
     * @param string $filehash
     *
     * @return FileContentInterface
     */
    public function setFilehash(string $filehash): FileContentInterface;
}
