<?php

declare(strict_types=1);

namespace Amasty\ReviewsImportExport\Model\ResourceModel;

use Magento\Framework\Model\AbstractModel;

class Review extends \Magento\Review\Model\ResourceModel\Review
{
    /**
     * @param AbstractModel $object
     * @return $this|\Magento\Review\Model\ResourceModel\Review
     */
    protected function _beforeSave(AbstractModel $object)
    {
        if (!$object->getId() && !$object->hasCreatedAt()) {
            $object->setCreatedAt($this->_date->gmtDate());
        }

        if ($object->hasData('stores') && is_array($object->getStores())) {
            $stores = $object->getStores();
            $stores[] = 0;
            $object->setStores($stores);
        } elseif ($object->hasData('stores')) {
            $object->setStores([$object->getStores(), 0]);
        }

        return $this;
    }
}
