<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Reindex from Admin for Magento 2
 */

namespace Amasty\Reindex\Controller\Adminhtml\Reindex;

use Amasty\Base\Model\CliPhpResolver;
use Amasty\Reindex\Controller\Adminhtml\AbstractReindex;
use Magento\Backend\App\Action;
use Magento\Framework\Shell;
use Magento\Indexer\Model\Indexer\CollectionFactory;

class MassReindex extends AbstractReindex
{
    /**
     * @var Collection
     */
    private $indexerCollection;

    public function __construct(
        CliPhpResolver $cliPhpResolver,
        Shell $shell,
        CollectionFactory $indexerCollectionFactory,
        Action\Context $context
    ) {
        $this->indexerCollection = $indexerCollectionFactory->create();
        parent::__construct($cliPhpResolver, $shell, $context);
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        if ($indexerIds = $this->getRequest()->getParam('indexer_ids')) {
            $indexers = $this->indexerCollection->getAllIds();
            foreach ($indexerIds as $key => $indexerId) {
                if (!in_array($indexerId, $indexers)) {
                    unset($indexerIds[$key]);
                    $this->messageManager->addWarningMessage(__('Unknown indexer code:' . $indexerId));
                }
            }
            if (!empty($indexerIds)) {
                $this->run($indexerIds);
            }
        }
        return $this->resultRedirectFactory->create()->setRefererUrl();
    }
}
