<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Reindex from Admin for Magento 2
 */

namespace Amasty\Reindex\Controller\Adminhtml;

use Amasty\Base\Model\CliPhpResolver;
use Magento\Backend\App\Action;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Shell;

abstract class AbstractReindex extends \Magento\Backend\App\Action
{
    public const ADMIN_RESOURCE = 'Magento_Indexer::index';

    /**
     * @var Shell
     */
    private $shell;

    /**
     * @var CliPhpResolver
     */
    private $cliPhpResolver;

    public function __construct(
        CliPhpResolver $cliPhpResolver,
        Shell $shell,
        Action\Context $context
    ) {
        parent::__construct($context);
        $this->cliPhpResolver = $cliPhpResolver;
        $this->shell = $shell;
    }

    /**
     * @param array $indexers
     */
    protected function run($indexers = [])
    {
        $phpPath = $this->cliPhpResolver->getExecutablePath();

        try {
            $this->shell->execute(
                $phpPath . ' %s indexer:reindex' . str_repeat(' %s', count($indexers)) . ' > /dev/null &',
                array_merge(
                    [BP . '/bin/magento'],
                    $indexers
                )
            );
            $this->messageManager->addSuccessMessage(__('Reindex process has been started in the background.'));
        } catch (LocalizedException $e) {
            $this->messageManager->addErrorMessage($e->getMessage());
        }
    }
}
